# Grouping Symbols Matching Using an Array-Based Stack

## 1. Introduction to Stacks

A **stack** is a linear data structure that follows the **LIFO (Last-In, First-Out)** principle; that is, the last element inserted is the first one to be removed.
Common operations on a stack are:

- **push(x):** adds an element to the top
- **pop():** removes the top element
- **top():** returns the top element without removing it
- **isEmpty():** checks if the stack is empty

When implemented using arrays, each of these operations can be performed in **O(1)** time.

---

## 2. The Grouping Symbols Matching Problem

The **grouping symbols matching** (or **balanced parentheses**) problem checks whether every opening symbol in an expression (e.g., `(`, `{`, `[`) has a corresponding closing symbol (e.g., `)`, `}`, `]`) in the correct order.

For example:

- `{[()]}` → balanced
- `{[(])}` → not balanced

A stack provides a natural and **efficient** solution:

- Traverse the string one character at a time.
- **Push** each opening symbol onto the stack.
- For each closing symbol, **check** if the stack is empty or if the top of the stack matches its corresponding opening symbol.
- If mismatched or extra symbols remain, the expression is unbalanced.

This algorithm runs in **O(n)** time and **O(n)** space, where _n_ is the length of the input string.

---

## 3. Stack Implementation Files

This project builds the stack **from scratch** using an array:

- **`Stack.java`**
  Defines the **Stack ADT** (Abstract Data Type) through an interface specifying standard stack operations (`push`, `pop`, `top`, `isEmpty`, `size`).

- **`StackException.java`**
  Defines a **custom exception class** thrown when illegal operations occur (e.g., popping from an empty stack or pushing to a full one).

- **`ArrayBasedStack.java`**
  Implements the `Stack` interface using a **fixed-size array** to store elements.
  The stack maintains a `top` index to track the most recently added element.

- **`ArrayBasedStackDemo.java`**
  Provides simple demonstrations of stack operations for testing and validation purposes.

---

## 4. Grouping Symbols Matching Algorithm

The core application of the stack appears in **`Main.java`**, which solves the grouping symbols matching problem.

**Algorithm Overview:**

1. Create an empty stack of characters.
2. For each character in the input string:

   - If it is an opening symbol (`(`, `{`, `[`), **push** it onto the stack.
   - If it is a closing symbol (`)`, `}`, `]`), check:

     - If the stack is empty → not balanced.
     - Otherwise, **pop** the top element and verify that it matches.

3. After traversal, if the stack is not empty → not balanced.
4. Otherwise → balanced expression.

**Complexity Analysis:**

- **Time Complexity:** O(n) — each character is processed once.
- **Space Complexity:** O(n) — in the worst case, all characters are pushed onto the stack.
